
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                         Quadruple Integer - test time loop                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
// Compile as Release x64 !

	loop++;
	fprintf(stderr, "\rtest loop %d: %s                  ", loop, TTT);

	// test X64 assembler
	{
		uint256 a, b, c, a0, b0, a02, b02;
		int shift = 0;
		u64 a2, b2;
		u32 a3;
		uint128 a4, b4;
		a2 = 1234567890123456789;
		b2 = 1234567890123456788;
		a3 = (u32)a2;
		a0 = a2;
		b0 = b2;
		a02 = a2;
		b02 = b2;
		a4 = a2;
		b4 = b2;
		a = a0 * a0 * a0 * a0;
		b = b0 * b0 * b0 * b0;
		a4 *= a4;
		b4 *= b4;
		a0 *= a0;
		b0 *= b0;
		uint256 ub;
		ub.Set(b);

		uint256 c_1, c_2, c_3, c_4, c_5, c_6;
		c.Set(1);
		int shift_1 = c_1.PreFastDiv(c);
		c.Set(2);
		int shift_2 = c_2.PreFastDiv(c);
		c.Set(0x8000);
		int shift_3 = c_3.PreFastDiv(c);
		c.Set(0x6756757678678678ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL);
		int shift_4 = c_4.PreFastDiv(c);
		c.Set(0x12);
		int shift_5 = c_5.PreFastDiv(c);
		int shift_6 = c_6.PreFastDiv(a);

		StartTime();
		for (i = k; i > 0; i--)
		{
			c = a;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
		}
		double td2 = GetTime();
		t1 += td2*1000000000/20/k;

		printf("// (" TTT ") %.1f ns / ", td2*1000000000/50/k);
	}

	// test C++
	{
		uint256ref a, b, c, a0, b0, a02, b02;
		int shift = 0;
		u64 a2, b2;
		u32 a3;
		uint128 a4, b4;
		a2 = 1234567890123456789;
		b2 = 1234567890123456788;
		a3 = (u32)a2;
		a0 = a2;
		b0 = b2;
		a02 = a2;
		b02 = b2;
		a4 = a2;
		b4 = b2;
		a = a0 * a0 * a0 * a0;
		b = b0 * b0 * b0 * b0;
		a4 *= a4;
		b4 *= b4;
		a0 *= a0;
		b0 *= b0;
		uint256ref ub;
		ub.Set(b);

		uint256ref c_1, c_2, c_3, c_4, c_5, c_6;
		c.Set(1);
		int shift_1 = c_1.PreFastDiv(c);
		c.Set(2);
		int shift_2 = c_2.PreFastDiv(c);
		c.Set(0x8000);
		int shift_3 = c_3.PreFastDiv(c);
		c.Set(0x6756757678678678ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL);
		int shift_4 = c_4.PreFastDiv(c);
		c.Set(0x12);
		int shift_5 = c_5.PreFastDiv(c);
		int shift_6 = c_6.PreFastDiv(a);

		StartTime();
		for (i = k; i > 0; i--)
		{
			c = a;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
		}
		double td2 = GetTime();
		t2 += td2*1000000000/20/k;

		printf("%.1f ns, ", td2*1000000000/50/k);
	}

	// test X64 assembler
	{
		sint256 a, b, c, a0, b0, a02, b02;
		int shift = 0;
		s64 a2, b2;
		s32 a3;
		sint128 a4, b4;
		a2 = 1234567890123456789;
		b2 = 1234567890123456788;
		a3 = (u32)a2;
		a0 = a2;
		b0 = b2;
		a02 = a2;
		b02 = b2;
		a4 = a2;
		b4 = b2;
		a = a0 * a0 * a0 * a0;
		b = b0 * b0 * b0 * b0;
		a4 *= a4;
		b4 *= b4;
		a0 *= a0;
		b0 *= b0;
		uint256 ub;
		ub.Set(b);

		sint256 c_1, c_2, c_3, c_4, c_5, c_6;
		c.Set(1);
		int shift_1 = c_1.PreFastDiv(c);
		c.Set(2);
		int shift_2 = c_2.PreFastDiv(c);
		c.Set(0x8000);
		int shift_3 = c_3.PreFastDiv(c);
		c.Set(0x6756757678678678ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL);
		int shift_4 = c_4.PreFastDiv(c);
		c.Set(0x12);
		int shift_5 = c_5.PreFastDiv(c);
		int shift_6 = c_6.PreFastDiv(a);

		StartTime();
		for (i = k; i > 0; i--)
		{
			c = a;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
		}
		double td2 = GetTime();
		t3 += td2*1000000000/20/k;

		printf("%.1f ns / ", td2*1000000000/50/k);
	}

	// test C++
	{
		sint256ref a, b, c, a0, b0, a02, b02;
		int shift = 0;
		s64 a2, b2;
		s32 a3;
		sint128 a4, b4;
		a2 = 1234567890123456789;
		b2 = 1234567890123456788;
		a3 = (u32)a2;
		a0 = a2;
		b0 = b2;
		a02 = a2;
		b02 = b2;
		a4 = a2;
		b4 = b2;
		a = a0 * a0 * a0 * a0;
		b = b0 * b0 * b0 * b0;
		a4 *= a4;
		b4 *= b4;
		a0 *= a0;
		b0 *= b0;
		uint256ref ub;
		ub.Set(b);

		sint256ref c_1, c_2, c_3, c_4, c_5, c_6;
		c.Set(1);
		int shift_1 = c_1.PreFastDiv(c);
		c.Set(2);
		int shift_2 = c_2.PreFastDiv(c);
		c.Set(0x8000);
		int shift_3 = c_3.PreFastDiv(c);
		c.Set(0x6756757678678678ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL,0xc5673446c5673446ULL);
		int shift_4 = c_4.PreFastDiv(c);
		c.Set(0x12);
		int shift_5 = c_5.PreFastDiv(c);
		int shift_6 = c_6.PreFastDiv(a);

		StartTime();
		for (i = k; i > 0; i--)
		{
			c = a;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
			KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK; KKK;
		}
		double td2 = GetTime();
		t4 += td2*1000000000/20/k;

		printf("%.1f ns\n", td2*1000000000/50/k);
	}

#undef KKK
#undef TTT
